/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioArrival;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public final class VWScenarioArrivalPattern
implements IVWScenarioArrival,
Serializable,
Cloneable {
    private VWScenarioWorkflowDefinition m_scenarioWFDef = null;
    private String m_name = null;
    private Object m_startTime = null;
    private Date m_acquireStartTime = null;
    private Object m_acquireEndTime = null;
    private float m_adjustFactor = 0.0f;
    private String m_dataSource = null;

    protected VWScenarioArrivalPattern(String name, Object startTime, Date acquireStartTime, Object acquireEndTime, float adjustFactor, String dataSource, VWScenarioWorkflowDefinition scenarioWFDef) throws VWException {
        this.m_scenarioWFDef = scenarioWFDef;
        this.setName(name);
        this.setStartTime(startTime);
        this.setAcquireStartTime(acquireStartTime);
        this.setAcquireEndTime(acquireEndTime);
        this.setAdjustFactor(adjustFactor);
        this.setDataSource(dataSource);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String theName) throws VWException {
        if (theName == null) {
            throw new VWException("sim.api.VWScenarioArrivalPattern.NullNameParameter", "The name parameter can not be null.");
        }
        if (theName.equals(this.m_name)) {
            return;
        }
        if (this.m_scenarioWFDef.hasArrival(theName)) {
            throw new VWException("sim.api.VWScenarioArrivalPattern.ArrivalAlreadyExists", "An arrival with the name {0} has already been created.", theName);
        }
        this.m_scenarioWFDef.updateArrival(this.m_name, theName);
        this.m_name = theName;
    }

    public Object getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Object startTime) throws VWException {
        if (!VWScenarioTimeType.isValid(startTime)) {
            throw new VWException("sim.api.VWScenarioArrivalPattern.InvalidTimeValue", "The value is a {0}, which is not a supported time type.", startTime != null ? startTime.getClass().getName() : null);
        }
        this.m_startTime = startTime;
    }

    public Date getAcquireStartTime() {
        return this.m_acquireStartTime;
    }

    public void setAcquireStartTime(Date startTime) {
        this.m_acquireStartTime = startTime;
    }

    public Object getAcquireEndTime() {
        return this.m_acquireEndTime;
    }

    public void setAcquireEndTime(Object endTime) throws VWException {
        if (!VWScenarioTimeType.isValid(endTime)) {
            throw new VWException("sim.api.VWScenarioArrivalPatternInvalidTimeValue", "The value is a {0}, which is not a supported time type.", endTime.getClass().getName());
        }
        this.m_acquireEndTime = endTime;
    }

    public float getAdjustFactor() {
        return this.m_adjustFactor;
    }

    public void setAdjustFactor(float adjustFactor) {
        this.m_adjustFactor = adjustFactor;
    }

    public String getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(String dataSource) {
        this.m_dataSource = dataSource;
    }

    public void validate(Vector EDefVector) throws VWException {
        VWScenarioDefinition scenario = this.m_scenarioWFDef.getScenario();
        Date absScenarioStartTime = scenario.getAbsoluteStartTime();
        Date absScenarioEndTime = scenario.getAbsoluteEndTime();
        if (this.m_adjustFactor <= -100.0f) {
            VWString theMessage = new VWString("sim.api.VWScenarioArrivalPattern.InvalidAdjustFactor", "The arrival adjust factor must be greater than or equal to -99.");
            VWScenarioValidationError theError = new VWScenarioValidationError(7, 1, this.getName(), null, theMessage.toString());
            EDefVector.addElement(theError);
        }
        VWScenarioTimeType.validate(this.getStartTime(), absScenarioStartTime, 7, this.getName(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
        Date absStartTime = VWScenarioTimeType.getAbsoluteTime(this.getStartTime());
        if (absStartTime != null) {
            boolean outOfRange = false;
            if (absScenarioStartTime != null && absStartTime.compareTo(absScenarioStartTime) < 0) {
                outOfRange = true;
            }
            if (absScenarioEndTime != null && absStartTime.compareTo(absScenarioEndTime) >= 0) {
                outOfRange = true;
            }
            if (outOfRange) {
                VWString theMessage = new VWString("vw.api.VWScenarioArrivalPattern.StartTimeOutOfRange", "Start date is out of range, arrival start date should fall between the simulation start and end date.", this.getName());
                VWScenarioValidationError theError = new VWScenarioValidationError(7, 1, this.getName(), null, theMessage.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName());
                EDefVector.addElement(theError);
            }
        }
        VWScenarioTimeType.validate(this.getAcquireStartTime(), absScenarioStartTime, 7, this.getName(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
        Date absAcquireStartTime = VWScenarioTimeType.getAbsoluteTime(this.getAcquireStartTime());
        VWScenarioTimeType.validate(this.getAcquireEndTime(), absAcquireStartTime, 7, this.getName(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
        Date absAcquireEndTime = VWScenarioTimeType.getAbsoluteTime(this.getAcquireEndTime());
        if (absAcquireStartTime != null && absAcquireEndTime != null && absAcquireEndTime.compareTo(absAcquireStartTime) <= 0) {
            VWString theMessage = new VWString("sim.api.VWScenarioArrivalPatter.AcquireEndTimeOutOfRange", "The arrival acquire end date must be greater than the acquire start date.");
            VWScenarioValidationError theError = new VWScenarioValidationError(7, 1, this.getName(), null, theMessage.toString());
            EDefVector.addElement(theError);
        }
    }

    protected Object clone(String arrivalName) {
        VWScenarioArrivalPattern clone = null;
        try {
            clone = (VWScenarioArrivalPattern)super.clone();
            clone.m_name = arrivalName;
            if (this.m_startTime != null) {
                clone.m_startTime = VWScenarioTimeType.clone(this.m_startTime);
            }
            if (this.m_acquireStartTime != null) {
                clone.m_acquireStartTime = (Date)VWScenarioTimeType.clone(this.m_acquireStartTime);
            }
            if (this.m_acquireEndTime != null) {
                clone.m_acquireEndTime = VWScenarioTimeType.clone(this.m_acquireEndTime);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public void toXML(StringBuffer buffer) throws VWException {
        this.toXML(buffer, "", false);
    }

    protected void toXML(StringBuffer buffer, String baseIndent, boolean runtime) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        VWWorkflowDefinition workflowDef = this.m_scenarioWFDef.getWorkflowDefinition(runtime);
        String runtimeId = workflowDef.getRuntimeId() != null ? workflowDef.getRuntimeId().toString() : "";
        buffer.append(baseIndent + "<AcquireItem ");
        buffer.append("Name=\"" + this.getName() + "\" ");
        buffer.append("AdjustFactor=\"" + this.m_adjustFactor + "\" ");
        buffer.append("DataSource=\"" + VWScenarioXMLHandler.toXMLString(this.m_dataSource) + "\" ");
        buffer.append(">\n");
        buffer.append(LEVEL_1_INDENT + "<Process ");
        buffer.append("Name=\"" + workflowDef.getName() + "\" ");
        buffer.append("Identifier=\"" + VWScenarioXMLHandler.toXMLString(runtimeId) + "\"/>\n");
        buffer.append(LEVEL_1_INDENT + "<StartTime>\n");
        VWScenarioTimeType.timeValueToXML(this.getAcquireStartTime(), buffer, LEVEL_2_INDENT);
        buffer.append(LEVEL_1_INDENT + "</StartTime>\n");
        buffer.append(LEVEL_1_INDENT + "<EndTime>\n");
        VWScenarioTimeType.timeValueToXML(this.getAcquireEndTime(), buffer, LEVEL_2_INDENT);
        buffer.append(LEVEL_1_INDENT + "</EndTime>\n");
        buffer.append(LEVEL_1_INDENT + "<SimStartTime>\n");
        VWScenarioTimeType.timeValueToXML(this.getStartTime(), buffer, LEVEL_2_INDENT);
        buffer.append(LEVEL_1_INDENT + "</SimStartTime>\n");
        buffer.append(baseIndent + "</AcquireItem>\n");
    }

    public String toString() {
        return this.getName();
    }
}

